(function(){
    const form = document.getElementById('searchform');
    if(!form){return;}
    // Optionally integrate ChatGPT Search via OpenAI
    // Requires window.openai_api_key to be set
    const input = form.querySelector('input[name="s"]');
    if(!input){return;}

    const aiBtn = document.createElement('button');
    aiBtn.type = 'button';
    aiBtn.textContent = 'AI Search';
    aiBtn.style.marginLeft = '0.5rem';
    form.appendChild(aiBtn);

    aiBtn.addEventListener('click', async function(){
        if(!window.openai_api_key){
            alert('Add openai_api_key to window to use AI search.');
            return;
        }
        const query = input.value.trim();
        if(!query){return;}
        aiBtn.disabled = true;
        aiBtn.textContent = 'Thinking…';
        try {
            const response = await fetch('https://api.openai.com/v1/chat/completions', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer ' + window.openai_api_key
                },
                body: JSON.stringify({
                    model: 'gpt-3.5-turbo',
                    messages: [
                        {role:'system', content:'You are a helpful search assistant for a blog.'},
                        {role:'user', content: query}
                    ],
                    max_tokens: 200
                })
            });
            const data = await response.json();
            alert(data.choices[0].message.content);
        } catch(e){
            console.error(e);
            alert('Error with AI search');
        } finally {
            aiBtn.disabled = false;
            aiBtn.textContent = 'AI Search';
        }
    });
})();
