<?php
function ek_ultrafast_scripts() {
    wp_enqueue_style('ek-style', get_stylesheet_uri(), [], '1.0');
    wp_enqueue_script('ek-chatgpt', get_template_directory_uri() . '/js/chatgpt-search.js', [], '1.0', true);
}
add_action('wp_enqueue_scripts', 'ek_ultrafast_scripts');

function ek_ultrafast_setup(){
    add_theme_support('title-tag');
    add_theme_support('html5', ['search-form','comment-form','comment-list','gallery','caption']);
}
add_action('after_setup_theme', 'ek_ultrafast_setup');

// Disable Gutenberg CSS
add_action('wp_enqueue_scripts', 'ek_unregister_wp_block_css', 100);
function ek_unregister_wp_block_css() {
    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-block-library-theme');
}

// Disable emojis
remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
remove_action( 'wp_print_styles', 'print_emoji_styles' );
?>
